﻿#include "stdafx.h"
#include "Webcam.h"

#using <mscorlib.dll>
#using <PresentationFramework.dll>
#using <WindowsBase.dll>
#using <PresentationCore.dll>

using namespace System;
using namespace System::Windows;
using namespace System::Windows::Controls;
using namespace System::Windows::Interop;
using namespace System::Runtime::InteropServices;

ref class MyHwndHost : HwndHost
{
protected: 
	virtual HandleRef BuildWindowCore(HandleRef hwndParent) override
	{
		HWND hwnd = CreateWindow(L"WebcamClass",			// Zarejestrowana klasa
						NULL,								// Tytuł
						WS_CHILD,							// Styl
						CW_USEDEFAULT, 0,					// Pozycja
						Webcam::GetWidth(),					// Szerokość
						Webcam::GetHeight(),				// Wysokość
						(HWND)hwndParent.Handle.ToInt32(),	// Obiekt nadrzędny
						NULL,								// Menu
						GetModuleHandle(NULL),				// hInstance
						NULL);								// Parametr opcjonalny

		if (hwnd == NULL)
			throw gcnew ApplicationException("CreateWindow failed!");

		Webcam::AttachToWindow(hwnd);

		return HandleRef(this, IntPtr(hwnd));
	}

	virtual void DestroyWindowCore(HandleRef hwnd) override
	{
		// To tylko formalność:
		::DestroyWindow((HWND)hwnd.Handle.ToInt32());
	}
};

ref class Window1 : Window
{
public:
	Window1()
	{
		DockPanel^ panel = gcnew DockPanel();
		MyHwndHost^ host = gcnew MyHwndHost();
		Label^ label = gcnew Label();
		label->FontSize = 20;
		label->Content = "Kontrolka Win32 zadokowana z lewej strony.";
		panel->Children->Add(host);
		panel->Children->Add(label);
		this->Content = panel;

		if (FAILED(Webcam::Initialize(640, 480)))
			::MessageBox(NULL, L"Brak komunikacji z urządzeniem rejestrującym obraz.", L"Error", 0);
		Webcam::Start();
	}

	~Window1()
	{
		Webcam::Terminate();
	}
};